function [commLabels Q reducedMat] = getCommunitiesMMSA(obj,varargin)


quiet = false;
for i = 1:numel(varargin)
    switch varargin{i}
        case 'quiet'
            quiet = true;
            
    end
end

[A labels] = getSquareMatrix(obj);

[Ci Q] = modularity_dir_SA(full(A));

if ~quiet, fprintf('Modularity of community structure: %.3f', Q); end

k = 1;
commLabels = {};
for i = 1:max(Ci)
    if ~quiet
        fprintf('\nCommunity %u\n',i);
        fprintf('%s, ',labels{Ci==i});
        fprintf('\n');
    end
    
    
    if ~isempty({labels{Ci==i}})
        
        % this caused some problems - ended up with empty matrices, which left
        % out some cells
        %         try
        %             matrices{k} = getSubMatrix(obj,{labels{Ci==i}});
        %         catch ME
        %             % do nothing; this is probably an empty matrix
        %             k = k-1;
        %         end
        commLabels{k} = {labels{Ci==i}};
    end
    k = k+1;
end

% Now create reduced AdjacencyMatrix
groups = {};
for i = 1:numel(commLabels)
    metaNodeName = sprintf('Module %u',i);
    groups = [groups metaNodeName {commLabels{i}}];
end

reducedMat = combineCells(obj,groups,groups');

end
